#!/bin/sh
SETEEPROM="/opt/RAYLASE/SPICE3/bin/seteeprom"
CACHEDIR="/tmp/eeprom"

function Die()
{
    echo $1
	exit 1
}

eepromcontent=$(${SETEEPROM}) || Die "seteeprom failed."
readarray -t lines <<< "$eepromcontent"

mkdir $CACHEDIR
length=${#lines[@]}
for (( i=0; i<${length}; i++ ));
do
    line=${lines[i]}
    [[ $line =~ ^([a-zA-Z0-9_:.]+)=([a-zA-Z0-9 _:.-]+)$ ]] || Die "Parsing failed."
    key=${BASH_REMATCH[1]}
    value=${BASH_REMATCH[2]}
    echo $value > "${CACHEDIR}/${key}.txt"
done

exit 0