#!/bin/bash
HOMESPICE3="/home/spice3"
HOMEWEBUSER="/home/webuser"

function Die()
{
    echo $1
    exit 1
}

function checkhomeowner()
{
    local homedir="$1"
    local owneruser="$2"
    local ownergroup="$3"
    local homeowner="$(stat --format '%U:%G' "${homedir}")"
    if ! [[ "${homeowner}" == "${owneruser}:${ownergroup}" ]]; then
        echo " - bad homeowner for '${homedir}': '${homeowner}' - correcting to '${owneruser}:${ownergroup}' ..."
        /bin/chown -R ${owneruser}:${ownergroup} "${homedir}"
        /bin/ls -la "${homedir}"
    fi
    return 0
}

echo "Checking home-owners..."
checkhomeowner "${HOMESPICE3}" "spice3" "spice3" 
checkhomeowner "${HOMEWEBUSER}" "webuser" "users" 

exit 0