# !/bin/bash
# Error Codes and Messages for the Update Daemon
#
# (c) RAYLASE GmbH 2020
#
# SOURCE this from upd_daemon.sh
#

#
# Note that we deliberately define these "error code constants" as numerical string values,
# rather than simple integers, because they will be passed as strings to the WebIF.
#

UPD_ERR_NONE='0'			#"No error"
UPD_ERR_NOIMGNUM='-1'		#"Error: no new image number specified."
UPD_ERR_NOIMGPART='-2'		#"Error: no new image partition specified."
UPD_ERR_NODEST='-3'		#"Error: no destination specified."
UPD_ERR_NOPKGNAME='-4'		#"Error: no update package name specified."
UPD_ERR_PKGNOTEXIST='-5'	#"Error: package '$1' does not exist."
UPD_ERR_PKGEXTRFAIL='-6'	#"Error: package '${updpkg}' extraction failed."
UPD_ERR_CPYTOFATFAIL='-7'	#"Error: copying '${UPD_DIR}/${f} to ${FATDIR}/${f}' failed."
UPD_ERR_UMNTIMGDIRFAIL='-8'	#"Error: Unmounting ${NEW_IMAGE_DIR} FAILED"
UPD_ERR_NOPKGINDIR='-9'		#"Error: Could not find an update package matching '{components,update}*.tar.bz2' in ${UPD_DIR}."

#
# Declare UPD_ERR_MSG as an associative array, so we can use the NAMES of the constants as keys.
#
declare -A UPD_ERR_MSG
UPD_ERR_MSG[UPD_ERR_NONE]='No error'
UPD_ERR_MSG[UPD_ERR_NOIMGNUM]='New image number not specified.'
UPD_ERR_MSG[UPD_ERR_NOIMGPART]='New image partition not specified.'
UPD_ERR_MSG[UPD_ERR_NODEST]='New image mount point not specified.'
UPD_ERR_MSG[UPD_ERR_NOPKGNAME]='Update package name not specified.'
UPD_ERR_MSG[UPD_ERR_PKGNOTEXIST]='Update package not found'
UPD_ERR_MSG[UPD_ERR_PKGEXTRFAIL]='Update package extraction failed'
UPD_ERR_MSG[UPD_ERR_CPYTOFATFAIL]='Component copy failed'
UPD_ERR_MSG[UPD_ERR_UMNTIMGDIRFAIL]='Unmount new image mount point failed'
UPD_ERR_MSG[UPD_ERR_NOPKGINDIR]='Could not find an update package matching "{components,update}*.tar.bz2" in '
