#!/bin/bash
### BEGIN INIT INFO
# Provides:          write-bootlog
# Required-Start:
# Required-Stop:
# Default-Start:     5
# Default-Stop:
# Short-Description: Store current boot log into file on home partition.
# Description:
### END INIT INFO

VARLOGBOOT='/var/log/boot'
SAVEBOOTLOG_DIR='/home/spice3/log'
BOOTLOG_NAME='boot'
BOOTLOG_EXT='log'
BOOTLOG_PATH="${SAVEBOOTLOG_DIR}/${BOOTLOG_NAME}.${BOOTLOG_EXT}"

[[ -f "${VARLOGBOOT}" ]] || { echo "Could not find ${VARLOGBOOT}" ; exit 0; }
[[ -d "${SAVEBOOTLOG_DIR}" ]] || { echo "Could not find ${SAVEBOOTLOG_DIR}" ; exit 0; }

if [[ -f "${BOOTLOG_PATH}" ]] && (( $(wc -c "${BOOTLOG_PATH}" | cut -d' ' -f1 ) >= 100000 )) ; then
	#
	# Delete old logs until there are at most 9 of them left.
	# NB: not using 'ls' because it doesn't cope gracefully with filepaths containing newlines (etc).
	#
	find "${SAVEBOOTLOG_DIR}" -maxdepth 1 -name 'boot.*.log' -type f -printf "%T+ %p\n" | sort -r | cut -d' ' -f2 | tail -n +10 | xargs -r rm -v --
	# Generate a boot.<TimeStamp>.log filename:
	SAVEBOOTLOG_FILENAME="$(date -u '+boot.%4Y-%2m-%2d.%2H%2M%2S.log')"
	# Rename the current boot log file
	mv -v "${BOOTLOG_PATH}" "${SAVEBOOTLOG_DIR}/${SAVEBOOTLOG_FILENAME}"
fi

BOOTLOGTIMESTAMP="$(date -u '+%4Y-%2m-%2d.%2H%2M%2S')"
echo -e "++++++++ Start of ${VARLOGBOOT} (copied at ${BOOTLOGTIMESTAMP}) ++++++++"  >> "${BOOTLOG_PATH}"
cat "${VARLOGBOOT}" >> "${BOOTLOG_PATH}"
echo -e "\n++++++++ End of ${VARLOGBOOT} (copied at ${BOOTLOGTIMESTAMP}) ++++++++\n"  >> "${BOOTLOG_PATH}"
