# !/bin/bash
# Unmount directories, which were mounted by the update script for SP-ICE-3
#
# V0.0.1 2015-02-02
# (c) RAYLASE GmbH


# Device node for MMC-Device
# For simulation on development host
MMCDEVICE=/dev/sdd
# On target system
# MMCDEVICE=/dev/mmcblk0p

# Partition numbers for partitions
FAT_PART=1
IMG0_PART=3
IMG1_PART=5
IMG2_PART=6
UPD_PART=7
DATA_PART=8

# Mount points
FAT_DIR=/media/fat
IMG0_DIR=/media/image0
IMG1_DIR=/media/image1
IMG2_DIR=/media/image2
UPD_DIR=/var/updates
HOME_DIR=/home



# Exit on fatal errors
fatal() {
	echo "************ Fatal error *************"
	echo $*
	echo "******** Terminating program *********"
	exit 1
}

# Mount required directories
unmountall() {
	for dirname in $FAT_DIR $IMG0_DIR $IMG1_DIR $IMG2_DIR $UPD_DIR $HOME_DIR ; do
		umount $dirname
	done
}

if [ X`whoami` != "Xroot" ] ; then
	fatal "Script has to be called as root"
fi

echo "Mounting working directories"
unmountall

