# !/bin/bash
# Update initialization script for SP-ICE-3
#
# (c) RAYLASE GmbH

VERSION="V1.0.2 "

export PATH="${PATH:+$PATH:}/usr/sbin:/sbin:/opt/RAYLASE/SPICE3/bin"

# Variable configuration and function definitions
. upd_functions.sh

# -----------------------------------------------------------------
#
# main function
#
logecho "Update Trigger $VERSION for SP-ICE-3 started"

if [ X`whoami` != "Xroot" ] ; then
	MSG="Update Trigger: must be called as root."
	echo "${MSG}"
	fatal "${MSG}"
fi


DAEMON_PID=$(tac /home/spice3/log/update.spice3.log | grep -i -m 1 "PID of Update Daemon"  | cut -d'=' -f2)
if [[ ( -z "${DAEMON_PID}" ) || ( "${DAEMON_PID}" -le 0 ) ]] ; then
	MSG="Update Trigger: failed to get Update Daemon PID."
	echo "${MSG}"
	fatal "${MSG}"
fi

MSG="Triggering Update Daemon (PID = ${DAEMON_PID})"
echo "${MSG}"
logecho "${MSG}"

kill -s HUP ${DAEMON_PID}



